<?php
if(corretto_restaurant_theme_installed()) {
	if(!function_exists('corretto_restaurant_meta_box_map')) {
		function corretto_restaurant_meta_box_map()
		{

			$restaurant_menu_meta_box = corretto_elated_create_meta_box(
				array(
					'scope' => array('restaurant-menu'),
					'title' => esc_html__('Restaurant Menu Item Settings', 'corretto-restaurant'),
					'name' => 'cafe_menu_item_meta'
				)
			);


			corretto_elated_create_meta_box_field(
				array(
					'name'          => 'restaurant_menu_item_price',
					'type'          => 'text',
					'default_value' => '',
					'label'         => esc_html__('Restaurant Menu Item Price', 'corretto-restaurant'),
					'description'   => esc_html__('Enter price for this restaurant menu item', 'corretto-restaurant'),
					'parent'        => $restaurant_menu_meta_box,
					'args'          => array(
						'col_width' => '3'
					)
				)
			);

            corretto_elated_create_meta_box_field(
				array(
					'name'          => 'restaurant_menu_item_description',
					'type'          => 'text',
					'default_value' => '',
					'label'         => esc_html__('Restaurant Menu Item Description', 'corretto-restaurant'),
					'description'   => esc_html__('Enter description for this restaurant menu item', 'corretto-restaurant'),
					'parent'        => $restaurant_menu_meta_box,
				)
			);
		}
		add_action('corretto_elated_meta_boxes_map', 'corretto_restaurant_meta_box_map');
	}
}