<?php

foreach ( glob( ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/blog/admin/meta-boxes/*/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'corretto_elated_map_blog_meta' ) ) {
	function corretto_elated_map_blog_meta() {
		$eltd_blog_categories = array();
		$categories           = get_categories();
		foreach ( $categories as $category ) {
			$eltd_blog_categories[ $category->slug ] = $category->name;
		}
		
		$blog_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => array( 'page' ),
				'title' => esc_html__( 'Blog', 'corretto' ),
				'name'  => 'blog_meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_category_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Blog Category', 'corretto' ),
				'description' => esc_html__( 'Choose category of posts to display (leave empty to display all categories)', 'corretto' ),
				'parent'      => $blog_meta_box,
				'options'     => $eltd_blog_categories
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_show_posts_per_page_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Posts', 'corretto' ),
				'description' => esc_html__( 'Enter the number of posts to display', 'corretto' ),
				'parent'      => $blog_meta_box,
				'options'     => $eltd_blog_categories,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_masonry_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Layout', 'corretto' ),
				'description' => esc_html__( 'Set masonry layout. Default is in grid.', 'corretto' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''           => esc_html__( 'Default', 'corretto' ),
					'in-grid'    => esc_html__( 'In Grid', 'corretto' ),
					'full-width' => esc_html__( 'Full Width', 'corretto' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_masonry_number_of_columns_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Number of Columns', 'corretto' ),
				'description' => esc_html__( 'Set number of columns for your masonry blog lists', 'corretto' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''      => esc_html__( 'Default', 'corretto' ),
					'two'   => esc_html__( '2 Columns', 'corretto' ),
					'three' => esc_html__( '3 Columns', 'corretto' ),
					'four'  => esc_html__( '4 Columns', 'corretto' ),
					'five'  => esc_html__( '5 Columns', 'corretto' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_masonry_space_between_items_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Space Between Items', 'corretto' ),
				'description' => esc_html__( 'Set space size between posts for your masonry blog lists', 'corretto' ),
				'options'     => corretto_elated_get_space_between_items_array( true ),
				'parent'      => $blog_meta_box
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_list_featured_image_proportion_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Featured Image Proportion', 'corretto' ),
				'description'   => esc_html__( 'Choose type of proportions you want to use for featured images on masonry blog lists', 'corretto' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''         => esc_html__( 'Default', 'corretto' ),
					'fixed'    => esc_html__( 'Fixed', 'corretto' ),
					'original' => esc_html__( 'Original', 'corretto' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_pagination_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Pagination Type', 'corretto' ),
				'description'   => esc_html__( 'Choose a pagination layout for Blog Lists', 'corretto' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''                => esc_html__( 'Default', 'corretto' ),
					'standard'        => esc_html__( 'Standard', 'corretto' ),
					'load-more'       => esc_html__( 'Load More', 'corretto' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'corretto' ),
					'no-pagination'   => esc_html__( 'No Pagination', 'corretto' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'type'          => 'text',
				'name'          => 'eltdf_number_of_chars_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Number of Words in Excerpt', 'corretto' ),
				'description'   => esc_html__( 'Enter a number of words in excerpt (article summary). Default value is 40', 'corretto' ),
				'parent'        => $blog_meta_box,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_blog_meta', 30 );
}