<?php

class CorrettoElatedAuthorInfoWidget extends CorrettoElatedWidget {
	public function __construct() {
		parent::__construct(
			'eltdf_author_info_widget',
			esc_html__( 'Elated Author Info Widget', 'corretto' ),
			array( 'description' => esc_html__( 'Add author info element to widget areas', 'corretto' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'  => 'textfield',
				'name'  => 'extra_class',
				'title' => esc_html__( 'Custom CSS Class', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'author_username',
				'title' => esc_html__( 'Author Username', 'corretto' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		extract( $args );
		
		$extra_class = '';
		if ( ! empty( $instance['extra_class'] ) ) {
			$extra_class = $instance['extra_class'];
		}
		
		$authorID = 1;
		if ( ! empty( $instance['author_username'] ) ) {
			$author = get_user_by( 'login', $instance['author_username'] );
			
			if ( $author ) {
				$authorID = $author->ID;
			}
		}
		
		$author_info = get_the_author_meta( 'email', $authorID );
		?>
		
		<div class="widget eltdf-author-info-widget <?php echo esc_attr( $extra_class ); ?>">
			<div class="eltdf-aiw-inner">
				<a itemprop="url" class="eltdf-aiw-image" href="<?php echo esc_url( get_author_posts_url( $authorID ) ); ?>">
					<?php echo corretto_elated_kses_img( get_avatar( $authorID, 138 ) ); ?>
				</a>
				<?php if ( $author_info !== "" ) { ?>
					<h5 class="eltdf-aiw-title"><?php echo get_the_author_meta( 'first_name' )." ".get_the_author_meta( 'last_name' )?></h5>
                    <span itemprop="description" class="eltdf-aiw-text"><p><?php echo wp_kses_post( $author_info ); ?></p></span>
                    <ul>
                        <li>
                            <a href="<?php echo get_the_author_meta( 'instagram' );?>" >
                                <span class="eltdf-social-network-icon social_instagram"></span>
                            </a>
                        </li><li>
                            <a href="<?php echo get_the_author_meta( 'twitter' );?>" >
                                <span class="eltdf-social-network-icon social_twitter"></span>
                            </a>
                        </li><li>
                            <a href="<?php echo get_the_author_meta( 'facebook' );?>" >
                                <span class="eltdf-social-network-icon social_facebook"></span>
                            </a>
                        </li><li>
                            <a href="<?php echo get_the_author_meta( 'linkedin' );?>" >
                                <span class="eltdf-social-network-icon social_linkedin"></span>
                            </a>
                        </li>
                    </ul>
				<?php } ?>
			</div>
		</div>
		<?php
	}
}