<?php

if ( ! function_exists( 'corretto_elated_woocommerce_options_map' ) ) {
	
	/**
	 * Add WooCommerce options page
	 */
	function corretto_elated_woocommerce_options_map() {
		
		corretto_elated_add_admin_page(
			array(
				'slug'  => '_woocommerce_page',
				'title' => esc_html__( 'WooCommerce', 'corretto' ),
				'icon'  => 'fa fa-shopping-cart'
			)
		);
		
		/**
		 * Product List Settings
		 */
		$panel_product_list = corretto_elated_add_admin_panel(
			array(
				'page'  => '_woocommerce_page',
				'name'  => 'panel_product_list',
				'title' => esc_html__( 'Product List', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_woo_product_list_columns',
				'label'         => esc_html__( 'Product List Columns', 'corretto' ),
				'default_value' => 'eltdf-woocommerce-columns-4',
				'description'   => esc_html__( 'Choose number of columns for main shop page', 'corretto' ),
				'options'       => array(
					'eltdf-woocommerce-columns-3' => esc_html__( '3 Columns', 'corretto' ),
					'eltdf-woocommerce-columns-4' => esc_html__( '4 Columns', 'corretto' )
				),
				'parent'        => $panel_product_list,
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_woo_product_list_columns_space',
				'label'         => esc_html__( 'Space Between Items', 'corretto' ),
				'description'   => esc_html__( 'Select space between items for product listing and related products on single product', 'corretto' ),
				'default_value' => 'normal',
				'options'       => corretto_elated_get_space_between_items_array(),
				'parent'        => $panel_product_list,
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_woo_product_list_info_position',
				'label'         => esc_html__( 'Product Info Position', 'corretto' ),
				'default_value' => 'info_below_image',
				'description'   => esc_html__( 'Select product info position for product listing and related products on single product', 'corretto' ),
				'options'       => array(
					'info_below_image'    => esc_html__( 'Info Below Image', 'corretto' ),
					'info_on_image_hover' => esc_html__( 'Info On Image Hover', 'corretto' )
				),
				'parent'        => $panel_product_list,
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'text',
				'name'          => 'eltdf_woo_products_per_page',
				'label'         => esc_html__( 'Number of products per page', 'corretto' ),
				'description'   => esc_html__( 'Set number of products on shop page', 'corretto' ),
				'parent'        => $panel_product_list,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_products_list_title_tag',
				'label'         => esc_html__( 'Products Title Tag', 'corretto' ),
				'default_value' => 'h5',
				'options'       => corretto_elated_get_title_tag(),
				'parent'        => $panel_product_list,
			)
		);
		
		/**
		 * Single Product Settings
		 */
		$panel_single_product = corretto_elated_add_admin_panel(
			array(
				'page'  => '_woocommerce_page',
				'name'  => 'panel_single_product',
				'title' => esc_html__( 'Single Product', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_woo',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single post pages', 'corretto' ),
				'parent'        => $panel_single_product,
				'options'       => corretto_elated_get_yes_no_select_array(),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_single_product_title_tag',
				'default_value' => 'h3',
				'label'         => esc_html__( 'Single Product Title Tag', 'corretto' ),
				'options'       => corretto_elated_get_title_tag(),
				'parent'        => $panel_single_product,
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_number_of_thumb_images',
				'default_value' => '4',
				'label'         => esc_html__( 'Number of Thumbnail Images per Row', 'corretto' ),
				'options'       => array(
					'4' => esc_html__( 'Four', 'corretto' ),
					'3' => esc_html__( 'Three', 'corretto' ),
					'2' => esc_html__( 'Two', 'corretto' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_set_thumb_images_position',
				'default_value' => 'below-image',
				'label'         => esc_html__( 'Set Thumbnail Images Position', 'corretto' ),
				'options'       => array(
					'below-image'  => esc_html__( 'Below Featured Image', 'corretto' ),
					'on-left-side' => esc_html__( 'On The Left Side Of Featured Image', 'corretto' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_enable_single_product_zoom_image',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Zoom Maginfier', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will show magnifier image on featured image hover', 'corretto' ),
				'parent'        => $panel_single_product,
				'options'       => corretto_elated_get_yes_no_select_array( false ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_set_single_images_behavior',
				'default_value' => 'pretty-photo',
				'label'         => esc_html__( 'Set Images Behavior', 'corretto' ),
				'options'       => array(
					'pretty-photo' => esc_html__( 'Pretty Photo Lightbox', 'corretto' ),
					'photo-swipe'  => esc_html__( 'Photo Swipe Lightbox', 'corretto' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_woo_related_products_columns',
				'label'         => esc_html__( 'Related Products Columns', 'corretto' ),
				'default_value' => 'eltdf-woocommerce-columns-4',
				'description'   => esc_html__( 'Choose number of columns for related products on single product page', 'corretto' ),
				'options'       => array(
					'eltdf-woocommerce-columns-3' => esc_html__( '3 Columns', 'corretto' ),
					'eltdf-woocommerce-columns-4' => esc_html__( '4 Columns', 'corretto' )
				),
				'parent'        => $panel_single_product,
			)
		);

		do_action('corretto_elated_woocommerce_additional_options_map');
	}
	
	add_action( 'corretto_elated_options_map', 'corretto_elated_woocommerce_options_map', 21 );
}