<?php
$i    = 0;
$rand = rand(0,1000);
?>
<div class="eltdf-image-gallery <?php echo esc_attr($holder_classes); ?>">
	<div class="eltdf-ig-inner eltdf-outer-space <?php echo esc_attr($inner_classes); ?>">
		<div class="eltdf-ig-grid-sizer"></div>
		<div class="eltdf-ig-grid-gutter"></div>
		<?php foreach ($images as $image) { ?>
			<?php
				$image_classes = '';

				if ($type == 'masonry-fixed') {
					$image_classes = 'eltdf-image-gallery-masonry-fixed ';
					$image_size_class    = get_post_meta( $image['image_id'], 'image_gallery_fixed_masonry_image_size', true );

					switch ($image_size_class) {
						case 'eltdf-default-masonry-item':
							$image_size = 'corretto_elated_square';
							break;
						case 'eltdf-large-width-masonry-item':
							$image_size = 'corretto_elated_landscape';
							break;
						case 'eltdf-large-height-masonry-item':
							$image_size = 'corretto_elated_portrait';
							break;
						case 'eltdf-large-width-height-masonry-item':
							$image_size = 'corretto_elated_huge';
							break;
						default:
							$image_size = 'corretto_elated_square';
							break;
					}

					if ($image_size_class == '') {
						$image_size_class = 'eltdf-default-masonry-item';
					}
				} else {
					$image_size_class    = get_post_meta( $image['image_id'], 'image_gallery_masonry_image_size', true );
				}

				if ( ! empty( $image_size_class ) ) {
					$image_classes .= esc_attr( $image_size_class );
				}
			?>
			<div class="eltdf-ig-image eltdf-item-space <?php echo esc_attr($image_classes); ?>">
				<div class="eltdf-ig-image-inner">
					<?php if ($image_behavior === 'lightbox') { ?>
						<a itemprop="image" class="eltdf-ig-lightbox" href="<?php echo esc_url($image['url']); ?>" data-rel="prettyPhoto[image_gallery_pretty_photo-<?php echo esc_attr($rand); ?>]" title="<?php echo esc_attr($image['title']); ?>">
							<span class="eltdf-ig-lightbox-icon icon_plus"></span>
					<?php } else if ($image_behavior === 'custom-link' && !empty($custom_links)) { ?>
						<a itemprop="url" class="eltdf-ig-custom-link" href="<?php echo esc_url($custom_links[$i++]); ?>" target="<?php echo esc_attr($custom_link_target); ?>" title="<?php echo esc_attr($image['title']); ?>">
					<?php } ?>
						<?php if(is_array($image_size) && count($image_size)) :
							echo corretto_elated_generate_thumbnail($image['image_id'], null, $image_size[0], $image_size[1]);
						else:
							echo wp_get_attachment_image($image['image_id'], $image_size);
						endif; ?>
					<?php if ($image_behavior === 'lightbox' || $image_behavior === 'custom-link') { ?>
						</a>
					<?php } ?>
				</div>
			</div>
		<?php } ?>
	</div>
</div>