<div <?php corretto_elated_class_attribute($holder_classes); ?> <?php corretto_elated_inline_style($holder_styles); ?>>
	<div class="eltdf-wh-holder-inner">
		<?php if($enable_frame === 'yes') : ?>
			<div class="eltdf-wh-frame"></div>
			<div class="eltdf-wh-frame-2"></div>
		<?php endif; ?>

		<?php if(is_array($working_hours) && count($working_hours)) : ?>
				<?php if($title !== '') : ?>
					<div class="eltdf-wh-title-holder">
						<h3 class="eltdf-wh-title"><?php echo esc_html($title); ?>
							<?php if($title_accent_word !== '') : ?>
								<span class="eltdf-wh-title-accent-word"><?php echo esc_html($title_accent_word); ?></span>
							<?php endif; ?>
						</h3>
					</div>
				<?php endif; ?>

			<?php foreach($working_hours as $working_hour) : ?>
				<div class="eltdf-wh-item clearfix">
					<span class="eltdf-wh-day">
						<span class="eltdf-wh-icon">
							<span class="icon_clock_alt"></span>
						</span>
						<?php echo esc_html($working_hour['label']); ?>
					</span>
					<span class="eltdf-wh-dots"><span class="eltdf-wh-dots-inner"></span></span>
					<span class="eltdf-wh-hours">
						<?php if(isset($working_hour['from']) && $working_hour['from'] !== '') : ?>
							<span class="eltdf-wh-from"><?php echo esc_html($working_hour['from']); ?></span>
						<?php endif; ?>

						<?php if(isset($working_hour['to']) && $working_hour['to'] !== '') : ?>
							<span class="eltdf-wh-delimiter">-</span>
							<span class="eltdf-wh-to"><?php echo esc_html($working_hour['to']); ?></span>
						<?php endif; ?>
					</span>
				</div>
			<?php endforeach; ?>
		<?php else: ?>
		<p><?php esc_html_e('Working hours are not set', 'corretto-restaurant'); ?></p>
		<?php endif; ?>
	</div>
</div>