<?php
class WC_Shipping_Purolator_Ajax {
	/**
	 * Constructor
	 *
	 * @since 2.4.0
	 * @version 2.4.0
	 *
	 */
	public function __construct() {
		include_once( 'class-wc-shipping-purolator.php' );

		if ( is_admin() ) {
			add_action( 'wp_ajax_woocommerce-purolator-get-label', array( $this, 'get_label' ) );
			add_action( 'wp_ajax_woocommerce-purolator-get-tracking', array( $this, 'render_get_tracking' ) );
			add_action( 'wp_ajax_woocommerce-purolator-void-shipment', array( $this, 'render_void_shipment' ) );
			add_action( 'wp_ajax_process_purolator_get_documents', array( $this, 'process_documents' ) );
		}
	}

	/**
	 * Get and print the Purolator label
	 *
	 * @access public
	 * @return void
	 */
	public function get_label() {

		if ( !is_admin() ) die;
		
		if ( !current_user_can('edit_shop_orders') ) wp_die( __( 'You do not have sufficient permissions to access this page.', 'woocommerce-shipping-purolator' ) );
		
		if ( !check_admin_referer( 'woocommerce-purolator-get-label' )) wp_die( __( 'You have taken too long. Please go back and retry.', 'woocommerce-shipping-purolator' ) );
		
		$order_id = isset($_GET['order_id']) && (int) $_GET['order_id'] ? (int) $_GET['order_id'] : '';
		
		if (!$order_id) die;

		$return = $this->process_label( $order_id );

		if( !empty( $return[ 'errors' ] ) ){
			echo( 'An error occured:<br />' );
			echo( implode( "<br />", $return[ 'errors' ] ) );
			die();
		}else{
			wp_redirect( $return[ 'label_url' ] );
			exit;
		}

	}

	public function process_label( $order_id ){
		$return = array(
			'errors'	=> array(),
			'label_url'	=> ''
		);
		$puro = get_post_meta( $order_id, "_purolator", true );

		if( $puro && isset( $puro[ 'label_url' ] ) && !empty( $puro[ 'label_url' ] ) ){

			$return[ 'label_url' ] = $puro[ 'label_url' ];

		}else{

			$order = wc_get_order( $order_id );
			$purolator = new WC_Shipping_Purolator();
			
			if( isset( $puro[ 'tracking_number' ] ) && !empty( $puro[ 'tracking_number' ] ) ){

				$shipment_pin = $puro[ 'tracking_number' ];

			}else{

			    $ret = $purolator->create_shipment( $order );
				$shipment_pin = $ret[ 'shipment_pin' ];

			}

			if( !empty( $shipment_pin ) ){

				$return[ 'label_url' ] = $purolator->get_documents( $shipment_pin );

				update_post_meta( $order_id, '_purolator', array( 'tracking_number' => $shipment_pin, 'label_url' => $return[ 'label_url' ] ) );

				update_post_meta( $order_id, 'Purolator Label Link', '<a href="' . admin_url( 'admin-ajax.php' ) . '?action=process_purolator_get_documents&order_id=' . $order_id . '">Print label</a>' );

				update_post_meta( $order_id, '_label_creation_date', time() );

				update_post_meta( $order_id, '_tracking_number', $shipment_pin );

			}else if( isset( $ret ) && isset( $ret[ 'errors' ] ) && !empty( $ret[ 'errors' ] ) ){

				$return[ 'errors' ] = $ret[ 'errors' ];

			}

		}

		return $return;
	}

	public function process_documents(){

		$order_id = $_GET[ 'order_id' ];

		$shipment_pin = get_post_meta( $order_id, '_tracking_number', true );

		if ( ! class_exists( 'WC_Shipping_Purolator' ) )
			include_once( 'includes/class-wc-shipping-purolator.php' );

		$purolator = new WC_Shipping_Purolator();

		if ( $shipment_pin ) {

			$label_url = $purolator->get_documents( $shipment_pin );
	
			
			if( !empty( $label_url ) ){

				wp_redirect( $label_url );
				exit;
			}else{

				echo('An error as occured');
				die();

			}

		}else{

			echo('An error as occured');
			die();

		}
	}

	/**
	 * Get the tracking
	 *
	 * @access public
	 * @return void
	 */
	public function render_get_tracking() {

		if ( !is_admin() ) die;
		if ( !current_user_can('edit_shop_orders') ) wp_die( __( 'You do not have sufficient permissions to access this page.', 'wc_purolator' ) );
		if ( !check_admin_referer( 'woocommerce-purolator-get-tracking' )) wp_die( __( 'You have taken too long. Please go back and retry.', 'wc_purolator' ) );
		$tracking_number = isset($_GET['tracking_number']) && (int) $_GET['tracking_number'] ? (int) $_GET['tracking_number'] : '';
		
		if (!$tracking_number) die;

		if ( ! class_exists( 'WC_Shipping_Purolator' ) )
			include_once( 'classes/class-wc-shipping-purolator.php' );

		if( $tracking_number ){

			$purolator = new WC_Shipping_Purolator();
			$scans = $purolator->get_tracking( $tracking_number );

			?>
		<table class="wp-list-table widefat fixed posts" cellspacing="0">
			<thead>
			<tr>
				<th scope="col" id="author" class="manage-column column-categories" style="border:1px solid #000;padding: 10px 10px;"><?php _e( "Date", "wc_purolator" ); ?></th>
				<th scope="col" id="author" class="manage-column column-categories" style="border:1px solid #000;padding: 10px 10px;"><?php _e( "Local Time", "wc_purolator" ); ?></th>
				<th scope="col" id="author" class="manage-column column-order_title" style="border:1px solid #000;padding: 10px 10px;"><?php _e( "Location", "wc_purolator" ); ?></th>
				<th scope="col" id="author" class="manage-column column-order_title" style="border:1px solid #000;padding: 10px 10px;"><?php _e( "Description", "wc_purolator" ); ?></th>
			</tr>
			</thead>

			<tbody id="the-list">
			<?php if( !empty( $scans ) ){ ?>

			<?php foreach( $scans as $key => $scan ){ ?>

				<tr id="tracking-<?php echo( $key + 1 ); ?>" class="tracking-<?php echo( $key + 1 ); ?> type-post format-standard hentry category-uncategorized alternate iedit author-self" valign="top">
					<td class="order_date column-categories" style="border:1px solid #000;padding: 10px 10px;"><?php echo( date_i18n( 'M j, Y', strtotime( $scan[ 'ScanDate' ] ) ) ); ?></td>
					<td class="order_date column-categories" style="border:1px solid #000;padding: 10px 10px;"><?php echo( date_i18n( 'G:i', strtotime( $scan[ 'ScanTime' ] ) ) ); ?></td>
					<td class="order_title column-order_title" style="border:1px solid #000;padding: 10px 10px;"><?php echo( $scan[ 'Depot' ][ 'Name' ] ); ?></td>
					<td class="order_title column-order_title" style="border:1px solid #000;padding: 10px 10px;"><?php echo( $scan[ 'Description' ] ); ?></td>
				</tr>

			<?php } ?>

			<?php } ?>
			</tbody>
		</table>
			<?php

		}

		die();
	}


	/**
	 * Void the shipment
	 *
	 * @access public
	 * @return void
	 */
	public function render_void_shipment() {

		if ( !is_admin() ) die;
		if ( !current_user_can('edit_shop_orders') ) wp_die( __( 'You do not have sufficient permissions to access this page.', 'wc_purolator' ) );
		if ( !check_admin_referer( 'woocommerce-purolator-void-shipment' )) wp_die( __( 'You have taken too long. Please go back and retry.', 'wc_purolator' ) );
		$tracking_number = isset($_GET['tracking_number']) && $_GET['tracking_number'] ? $_GET['tracking_number'] : '';
		$order_id = isset($_GET['order_id']) && (int) $_GET['order_id'] ? (int) $_GET['order_id'] : '';
		if (!$tracking_number) die;

		if ( ! class_exists( 'WC_Shipping_Purolator' ) )
			include_once( 'classes/class-wc-shipping-purolator.php' );

		if( $tracking_number ){

			$purolator = new WC_Shipping_Purolator();
			$shipment_voided = $purolator->void_shipment( $tracking_number );

			if( $shipment_voided[ 'voided' ] ){

				delete_post_meta( $order_id, '_purolator' );

				delete_post_meta( $order_id, '_tracking_number' );

			}

			?>
			<p>
				<?php if( $shipment_voided[ 'voided' ] ){ ?>
				<?php _e( "The shipment has been canceled.", "wc_purolator" ); ?>
				<?php }else{ ?>
				<?php echo( sprintf( __( "An error occured: %s ", "wc_purolator" ), implode( ', ', $shipment_voided[ 'errors' ] ) ) ); ?>
				<?php } ?>
			</p>

			<?php

		}

		die();

	}
}

new WC_Shipping_Purolator_Ajax();
