<?php

if ( ! function_exists( 'corretto_elated_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function corretto_elated_reset_options_map() {
		
		corretto_elated_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'corretto' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = corretto_elated_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'corretto' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'corretto' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'corretto_elated_options_map', 'corretto_elated_reset_options_map', 100 );
}