<?php

if ( ! function_exists( 'corretto_elated_map_woocommerce_meta' ) ) {
	function corretto_elated_map_woocommerce_meta() {
		
		$woocommerce_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'corretto' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'corretto' ),
				'description' => esc_html__( 'Choose image layout when it appears in Elated Product List - Masonry layout shortcode', 'corretto' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'corretto' ),
					'small'              => esc_html__( 'Small', 'corretto' ),
					'large-width'        => esc_html__( 'Large Width', 'corretto' ),
					'large-height'       => esc_html__( 'Large Height', 'corretto' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'corretto' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'corretto' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'corretto' ),
				'options'       => corretto_elated_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'corretto' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_woocommerce_meta', 99 );
}