(function($) {
    'use strict';
	
	var imageGallery = {};
	eltdf.modules.imageGallery = imageGallery;
	
	imageGallery.eltdfInitImageGalleryMasonry = eltdfInitImageGalleryMasonry;
	
	
	imageGallery.eltdfOnWindowLoad = eltdfOnWindowLoad;
	
	$(window).on('load', eltdfOnWindowLoad);
	
	/*
	 ** All functions to be called on $(window).load() should be in this function
	 */
	function eltdfOnWindowLoad() {
		eltdfInitImageGalleryMasonry();
	}
	
	/*
	 ** Init Image Gallery shortcode - Masonry layout
	 */
	function eltdfInitImageGalleryMasonry(){
		var holder = $('.eltdf-image-gallery.eltdf-ig-masonry-type');
		
		if(holder.length){
			holder.each(function(){
				var thisHolder = $(this),
					masonry = thisHolder.find('.eltdf-ig-masonry'),
					size = masonry.find('.eltdf-ig-grid-sizer').width();
				
				masonry.waitForImages(function() {
					masonry.isotope({
						layoutMode: 'packery',
						itemSelector: '.eltdf-ig-image',
						percentPosition: true,
						packery: {
							gutter: '.eltdf-ig-grid-gutter',
							columnWidth: '.eltdf-ig-grid-sizer'
						}
					});

					if (thisHolder.hasClass('eltdf-ig-masonry-fixed-type')) {					
						eltdfResizeImageMasonryLayoutItems(size, masonry);
					}

					setTimeout(function() {
						masonry.isotope('layout');
						eltdf.modules.common.eltdfInitParallax();
					}, 800);
					
					masonry.css('opacity', '1');
				});
			});
		}
	}

	function eltdfResizeImageMasonryLayoutItems(size,container){
		var space_between_items = parseInt(container.find('.eltdf-ig-image').css('paddingLeft')),
			space_between_items_size = space_between_items !== undefined && space_between_items !== '' ? parseInt(space_between_items, 10) : 0,
			newSize = size - 2 * space_between_items_size,
			defaultMasonryItem = container.find('.eltdf-default-masonry-item'),
			largeWidthMasonryItem = container.find('.eltdf-large-width-masonry-item'),
			largeHeightMasonryItem = container.find('.eltdf-large-height-masonry-item'),
			largeWidthHeightMasonryItem = container.find('.eltdf-large-width-height-masonry-item');
		
		if (eltdf.windowWidth > 680) {
			defaultMasonryItem.css('height', newSize);
			largeHeightMasonryItem.css('height', Math.round(2 * ( newSize + space_between_items_size )));
			largeWidthHeightMasonryItem.css('height', Math.round(2 * ( newSize + space_between_items_size )));
			largeWidthMasonryItem.css('height', newSize);
		} else {
			defaultMasonryItem.css('height', newSize);
			largeHeightMasonryItem.css('height', Math.round(2 * ( newSize + space_between_items_size )));
			largeWidthHeightMasonryItem.css('height', newSize);
			largeWidthMasonryItem.css('height', Math.round(newSize / 2));
		}
	}

})(jQuery);