<?php

if ( ! function_exists( 'corretto_core_import_object' ) ) {
	function corretto_core_import_object() {
		$corretto_core_import_object = new CorrettoCoreImport();
	}
	
	add_action( 'init', 'corretto_core_import_object' );
}

if ( ! function_exists( 'corretto_core_data_import' ) ) {
	function corretto_core_data_import() {
		$importObject = CorrettoCoreImport::getInstance();
		
		if ( $_POST['import_attachments'] == 1 ) {
			$importObject->attachments = true;
		} else {
			$importObject->attachments = false;
		}
		
		$folder = "corretto/";
		if ( ! empty( $_POST['example'] ) ) {
			$folder = $_POST['example'] . "/";
		}
		
		$importObject->import_content( $folder . $_POST['xml'] );
		
		die();
	}
	
	add_action( 'wp_ajax_corretto_core_data_import', 'corretto_core_data_import' );
}

if ( ! function_exists( 'corretto_core_widgets_import' ) ) {
	function corretto_core_widgets_import() {
		$importObject = CorrettoCoreImport::getInstance();
		
		$folder = "corretto/";
		if ( ! empty( $_POST['example'] ) ) {
			$folder = $_POST['example'] . "/";
		}
		
		$importObject->import_widgets( $folder . 'widgets.txt', $folder . 'custom_sidebars.txt' );
		
		die();
	}
	
	add_action( 'wp_ajax_corretto_core_widgets_import', 'corretto_core_widgets_import' );
}

if ( ! function_exists( 'corretto_core_options_import' ) ) {
	function corretto_core_options_import() {
		$importObject = CorrettoCoreImport::getInstance();
		
		$folder = "corretto/";
		if ( ! empty( $_POST['example'] ) ) {
			$folder = $_POST['example'] . "/";
		}
		
		$importObject->import_options( $folder . 'options.txt' );
		$importObject->eltdf_update_options_after_import($folder);
		die();
	}
	
	add_action( 'wp_ajax_corretto_core_options_import', 'corretto_core_options_import' );
}

if ( ! function_exists( 'corretto_core_other_import' ) ) {
	function corretto_core_other_import() {
		$importObject = CorrettoCoreImport::getInstance();
		
		$folder = "corretto/";
		if ( ! empty( $_POST['example'] ) ) {
			$folder = $_POST['example'] . "/";
		}
		
		$importObject->import_options( $folder . 'options.txt' );
		$importObject->import_widgets( $folder . 'widgets.txt', $folder . 'custom_sidebars.txt' );
		$importObject->import_menus( $folder . 'menus.txt' );
		$importObject->import_settings_pages( $folder . 'settingpages.txt' );

		$importObject->eltdf_update_meta_fields_after_import($folder);
		$importObject->eltdf_update_options_after_import($folder);

		if ( corretto_core_is_revolution_slider_installed() ) {
			$importObject->rev_slider_import( $folder );
		}
		
		die();
	}
	
	add_action( 'wp_ajax_corretto_core_other_import', 'corretto_core_other_import' );
}