<?php

if ( ! function_exists( 'corretto_core_map_portfolio_settings_meta' ) ) {
	function corretto_core_map_portfolio_settings_meta() {
		$meta_box = corretto_elated_create_meta_box( array(
			'scope' => 'portfolio-item',
			'title' => esc_html__( 'Portfolio Settings', 'corretto-core' ),
			'name'  => 'portfolio_settings_meta_box'
		) );
		
		corretto_elated_create_meta_box_field( array(
			'name'        => 'eltdf_portfolio_single_template_meta',
			'type'        => 'select',
			'label'       => esc_html__( 'Portfolio Type', 'corretto-core' ),
			'description' => esc_html__( 'Choose a default type for Single Project pages', 'corretto-core' ),
			'parent'      => $meta_box,
			'options'     => array(
				''                  => esc_html__( 'Default', 'corretto-core' ),
				'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'corretto-core' ),
				'images'            => esc_html__( 'Portfolio Images', 'corretto-core' ),
				'small-images'      => esc_html__( 'Portfolio Small Images', 'corretto-core' ),
				'slider'            => esc_html__( 'Portfolio Slider', 'corretto-core' ),
				'small-slider'      => esc_html__( 'Portfolio Small Slider', 'corretto-core' ),
				'gallery'           => esc_html__( 'Portfolio Gallery', 'corretto-core' ),
				'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'corretto-core' ),
				'masonry'           => esc_html__( 'Portfolio Masonry', 'corretto-core' ),
				'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'corretto-core' ),
				'custom'            => esc_html__( 'Portfolio Custom', 'corretto-core' ),
				'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'corretto-core' )
			)
		) );
		
		/***************** Gallery Layout *****************/
		
		$gallery_type_meta_container = corretto_elated_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'eltdf_gallery_type_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_portfolio_single_template_meta'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_single_gallery_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'corretto-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'corretto-core' ),
				'parent'        => $gallery_type_meta_container,
				'options'       => array(
					''      => esc_html__( 'Default', 'corretto-core' ),
					'two'   => esc_html__( '2 Columns', 'corretto-core' ),
					'three' => esc_html__( '3 Columns', 'corretto-core' ),
					'four'  => esc_html__( '4 Columns', 'corretto-core' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_single_gallery_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'corretto-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'corretto-core' ),
				'default_value' => '',
				'options'       => corretto_elated_get_space_between_items_array( true ),
				'parent'        => $gallery_type_meta_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$masonry_type_meta_container = corretto_elated_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'eltdf_masonry_type_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_masonry_type_meta_container'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_single_masonry_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'corretto-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'corretto-core' ),
				'parent'        => $masonry_type_meta_container,
				'options'       => array(
					''      => esc_html__( 'Default', 'corretto-core' ),
					'two'   => esc_html__( '2 Columns', 'corretto-core' ),
					'three' => esc_html__( '3 Columns', 'corretto-core' ),
					'four'  => esc_html__( '4 Columns', 'corretto-core' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_single_masonry_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'corretto-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'corretto-core' ),
				'default_value' => '',
				'options'       => corretto_elated_get_space_between_items_array( true ),
				'parent'        => $masonry_type_meta_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_portfolio_single_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single portfolio page', 'corretto-core' ),
				'parent'        => $meta_box,
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'portfolio_info_top_padding',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Info Top Padding', 'corretto-core' ),
				'description' => esc_html__( 'Set top padding for portfolio info elements holder. This option works only for Portfolio Images, Slider, Gallery and Masonry portfolio types', 'corretto-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'portfolio_external_link',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio External Link', 'corretto-core' ),
				'description' => esc_html__( 'Enter URL to link from Portfolio List page', 'corretto-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_portfolio_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Featured Image', 'corretto-core' ),
				'description' => esc_html__( 'Choose an image for Portfolio Lists shortcode where Hover Type option is Switch Featured Images', 'corretto-core' ),
				'parent'      => $meta_box
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_masonry_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Fixed Proportion', 'corretto-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is fixed', 'corretto-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''                   => esc_html__( 'Default', 'corretto-core' ),
					'small'              => esc_html__( 'Small', 'corretto-core' ),
					'large-width'        => esc_html__( 'Large Width', 'corretto-core' ),
					'large-height'       => esc_html__( 'Large Height', 'corretto-core' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'corretto-core' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_portfolio_masonry_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Original Proportion', 'corretto-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is original', 'corretto-core' ),
				'default_value' => 'default',
				'parent'        => $meta_box,
				'options'       => array(
					'default'     => esc_html__( 'Default', 'corretto-core' ),
					'large-width' => esc_html__( 'Large Width', 'corretto-core' )
				)
			)
		);
		
		$all_pages = array();
		$pages     = get_pages();
		foreach ( $pages as $page ) {
			$all_pages[ $page->ID ] = $page->post_title;
		}
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'portfolio_single_back_to_link',
				'type'        => 'select',
				'label'       => esc_html__( '"Back To" Link', 'corretto-core' ),
				'description' => esc_html__( 'Choose "Back To" page to link from portfolio Single Project page', 'corretto-core' ),
				'parent'      => $meta_box,
				'options'     => $all_pages,
				'args'        => array(
					'select2' => true
				)
			)
		);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_core_map_portfolio_settings_meta', 41 );
}