<?php

if ( ! function_exists( 'corretto_elated_portfolio_options_map' ) ) {
	function corretto_elated_portfolio_options_map() {
		
		corretto_elated_add_admin_page(
			array(
				'slug'  => '_portfolio',
				'title' => esc_html__( 'Portfolio', 'corretto-core' ),
				'icon'  => 'fa fa-camera-retro'
			)
		);
		
		$panel_archive = corretto_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Archive', 'corretto-core' ),
				'name'  => 'panel_portfolio_archive',
				'page'  => '_portfolio'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'        => 'portfolio_archive_number_of_items',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Items', 'corretto-core' ),
				'description' => esc_html__( 'Set number of items for your portfolio list on archive pages. Default value is 12', 'corretto-core' ),
				'parent'      => $panel_archive,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_archive_number_of_columns',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'corretto-core' ),
				'default_value' => '4',
				'description'   => esc_html__( 'Set number of columns for your portfolio list on archive pages. Default value is 4 columns', 'corretto-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'2' => esc_html__( '2 Columns', 'corretto-core' ),
					'3' => esc_html__( '3 Columns', 'corretto-core' ),
					'4' => esc_html__( '4 Columns', 'corretto-core' ),
					'5' => esc_html__( '5 Columns', 'corretto-core' )
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_archive_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'corretto-core' ),
				'description'   => esc_html__( 'Set space size between portfolio items for your portfolio list on archive pages. Default value is normal', 'corretto-core' ),
				'default_value' => 'normal',
				'options'       => corretto_elated_get_space_between_items_array(),
				'parent'        => $panel_archive
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_archive_image_size',
				'type'          => 'select',
				'label'         => esc_html__( 'Image Proportions', 'corretto-core' ),
				'default_value' => 'landscape',
				'description'   => esc_html__( 'Set image proportions for your portfolio list on archive pages. Default value is landscape', 'corretto-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'full'      => esc_html__( 'Original', 'corretto-core' ),
					'landscape' => esc_html__( 'Landscape', 'corretto-core' ),
					'portrait'  => esc_html__( 'Portrait', 'corretto-core' ),
					'square'    => esc_html__( 'Square', 'corretto-core' )
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_archive_item_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Item Style', 'corretto-core' ),
				'default_value' => 'standard-shader',
				'description'   => esc_html__( 'Set item style for your portfolio list on archive pages. Default value is Standard - Shader', 'corretto-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'standard-shader' => esc_html__( 'Standard - Shader', 'corretto-core' ),
					'gallery-overlay' => esc_html__( 'Gallery - Overlay', 'corretto-core' )
				)
			)
		);
		
		$panel = corretto_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Single', 'corretto-core' ),
				'name'  => 'panel_portfolio_single',
				'page'  => '_portfolio'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_template',
				'type'          => 'select',
				'label'         => esc_html__( 'Portfolio Type', 'corretto-core' ),
				'default_value' => 'small-images',
				'description'   => esc_html__( 'Choose a default type for Single Project pages', 'corretto-core' ),
				'parent'        => $panel,
				'options'       => array(
					'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'corretto-core' ),
					'images'            => esc_html__( 'Portfolio Images', 'corretto-core' ),
					'small-images'      => esc_html__( 'Portfolio Small Images', 'corretto-core' ),
					'slider'            => esc_html__( 'Portfolio Slider', 'corretto-core' ),
					'small-slider'      => esc_html__( 'Portfolio Small Slider', 'corretto-core' ),
					'gallery'           => esc_html__( 'Portfolio Gallery', 'corretto-core' ),
					'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'corretto-core' ),
					'masonry'           => esc_html__( 'Portfolio Masonry', 'corretto-core' ),
					'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'corretto-core' ),
					'custom'            => esc_html__( 'Portfolio Custom', 'corretto-core' ),
					'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'corretto-core' )
				)
			)
		);
		
		/***************** Gallery Layout *****************/
		
		$portfolio_gallery_container = corretto_elated_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_gallery_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'corretto-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'corretto-core' ),
				'parent'        => $portfolio_gallery_container,
				'options'       => array(
					'two'   => esc_html__( '2 Columns', 'corretto-core' ),
					'three' => esc_html__( '3 Columns', 'corretto-core' ),
					'four'  => esc_html__( '4 Columns', 'corretto-core' )
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'corretto-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'corretto-core' ),
				'default_value' => 'normal',
				'options'       => corretto_elated_get_space_between_items_array(),
				'parent'        => $portfolio_gallery_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$portfolio_masonry_container = corretto_elated_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_masonry_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'corretto-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'corretto-core' ),
				'parent'        => $portfolio_masonry_container,
				'options'       => array(
					'two'   => esc_html__( '2 Columns', 'corretto-core' ),
					'three' => esc_html__( '3 Columns', 'corretto-core' ),
					'four'  => esc_html__( '4 Columns', 'corretto-core' )
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'corretto-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'corretto-core' ),
				'default_value' => 'normal',
				'options'       => corretto_elated_get_space_between_items_array(),
				'parent'        => $portfolio_masonry_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_portfolio_single',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single projects', 'corretto-core' ),
				'parent'        => $panel,
				'options'       => array(
					''    => esc_html__( 'Default', 'corretto-core' ),
					'yes' => esc_html__( 'Yes', 'corretto-core' ),
					'no'  => esc_html__( 'No', 'corretto-core' )
				),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_images',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Images', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for projects with images', 'corretto-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_videos',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Videos', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects', 'corretto-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_enable_categories',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Categories', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will enable category meta description on single projects', 'corretto-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_date',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Date', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will enable date meta on single projects', 'corretto-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_sticky_sidebar',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Sticky Side Text', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will make side text sticky on Single Project pages. This option works only for Full Width Images, Small Images, Small Gallery and Small Masonry portfolio types', 'corretto-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_comments',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Comments', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will show comments on your page', 'corretto-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_pagination',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Hide Pagination', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will turn off portfolio pagination functionality', 'corretto-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		$container_navigate_category = corretto_elated_add_admin_container(
			array(
				'name'            => 'navigate_same_category_container',
				'parent'          => $panel,
				'dependency' => array(
					'hide' => array(
						'portfolio_single_hide_pagination'  => array(
							'yes'
						)
					)
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'portfolio_single_nav_same_category',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Pagination Through Same Category', 'corretto-core' ),
				'description'   => esc_html__( 'Enabling this option will make portfolio pagination sort through current category', 'corretto-core' ),
				'parent'        => $container_navigate_category,
				'default_value' => 'no'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'        => 'portfolio_single_slug',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Single Slug', 'corretto-core' ),
				'description' => esc_html__( 'Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)', 'corretto-core' ),
				'parent'      => $panel,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'corretto_elated_options_map', 'corretto_elated_portfolio_options_map', 14 );
}