<?php

if ( ! function_exists( 'corretto_elated_footer_options_map' ) ) {
	function corretto_elated_footer_options_map() {

		corretto_elated_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'corretto' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = corretto_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'corretto' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		corretto_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'corretto' ),
				'parent'        => $footer_panel
			)
		);

		corretto_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'uncovering_footer',
				'default_value' => 'no',
				'label'         => esc_html__( 'Uncovering Footer', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'corretto' ),
				'parent'        => $footer_panel,
			)
		);

		corretto_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'corretto' ),
				'parent'        => $footer_panel,
			)
		);
		
		$show_footer_top_container = corretto_elated_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'corretto' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'corretto' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
					'3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'corretto' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'corretto' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'corretto' ),
					'left'   => esc_html__( 'Left', 'corretto' ),
					'center' => esc_html__( 'Center', 'corretto' ),
					'right'  => esc_html__( 'Right', 'corretto' )
				),
				'parent'        => $show_footer_top_container,
			)
		);

		corretto_elated_add_admin_field(
			array(
				'name'        => 'footer_top_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'corretto' ),
				'description' => esc_html__( 'Set background color for top footer area', 'corretto' ),
				'parent'      => $show_footer_top_container
			)
		);

		corretto_elated_add_admin_field(
			array(
				'name'        => 'footer_top_background_image',
				'type'        => 'image',
				'label'       => esc_html__( 'Background Image', 'corretto' ),
				'description' => esc_html__( 'Set background image for top footer area', 'corretto' ),
				'parent'      => $show_footer_top_container
			)
		);

		corretto_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'corretto' ),
				'parent'        => $footer_panel,
			)
		);

		$show_footer_bottom_container = corretto_elated_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		corretto_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '3 6 3',
				'label'         => esc_html__( 'Footer Bottom Columns', 'corretto' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'corretto' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
					'3 6 3' => '3 (25% + 50% + 25%)'
				),
				'parent'        => $show_footer_bottom_container,
			)
		);

		corretto_elated_add_admin_field(
			array(
				'name'        => 'footer_bottom_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'corretto' ),
				'description' => esc_html__( 'Set background color for bottom footer area', 'corretto' ),
				'parent'      => $show_footer_bottom_container
			)
		);
	}

	add_action( 'corretto_elated_options_map', 'corretto_elated_footer_options_map', 11 );
}