<?php

if(corretto_restaurant_theme_installed()) {
	if(!function_exists('corretto_restaurant_options_map')) {
		/**
		 * Adds admin page for OpenTable integration
		 */
		function corretto_restaurant_options_map() {
			corretto_elated_add_admin_page(array(
				'title' => esc_html__('Restaurant', 'corretto-restaurant'),
				'slug'  => '_restaurant',
				'icon'  => 'fa fa-cutlery'
			));

			//#Working Hours panel
			$panel_working_hours = corretto_elated_add_admin_panel(array(
				'page'  => '_restaurant',
				'name'  => 'panel_working_hours',
				'title' => esc_html__('Working Hours', 'corretto-restaurant')
			));

			$monday_group = corretto_elated_add_admin_group(array(
				'name'        => 'monday_group',
				'title'       => esc_html__('Monday', 'corretto-restaurant'),
				'parent'      => $panel_working_hours,
				'description' => esc_html__('Working hours for Monday', 'corretto-restaurant')
			));

			$monday_row = corretto_elated_add_admin_row(array(
				'name'   => 'monday_row',
				'parent' => $monday_group
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_monday_from',
				'type'   => 'textsimple',
				'label'  => esc_html__('From', 'corretto-restaurant'),
				'parent' => $monday_row
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_monday_to',
				'type'   => 'textsimple',
				'label'  => esc_html__('To', 'corretto-restaurant'),
				'parent' => $monday_row
			));

			$tuesday_group = corretto_elated_add_admin_group(array(
				'name'        => 'tuesday_group',
				'title'       => esc_html__('Tuesday', 'corretto-restaurant'),
				'parent'      => $panel_working_hours,
				'description' => esc_html__('Working hours for Tuesday', 'corretto-restaurant')
			));

			$tuesday_row = corretto_elated_add_admin_row(array(
				'name'   => 'tuesday_row',
				'parent' => $tuesday_group
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_tuesday_from',
				'type'   => 'textsimple',
				'label'  => esc_html__('From', 'corretto-restaurant'),
				'parent' => $tuesday_row
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_tuesday_to',
				'type'   => 'textsimple',
				'label'  => esc_html__('To', 'corretto-restaurant'),
				'parent' => $tuesday_row
			));

			$wednesday_group = corretto_elated_add_admin_group(array(
				'name'        => 'wednesday_group',
				'title'       => esc_html__('Wednesday', 'corretto-restaurant'),
				'parent'      => $panel_working_hours,
				'description' => esc_html__('Working hours for Wednesday', 'corretto-restaurant')
			));

			$wednesday_row = corretto_elated_add_admin_row(array(
				'name'   => 'wednesday_row',
				'parent' => $wednesday_group
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_wednesday_from',
				'type'   => 'textsimple',
				'label'  => esc_html__('From', 'corretto-restaurant'),
				'parent' => $wednesday_row
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_wednesday_to',
				'type'   => 'textsimple',
				'label'  => esc_html__('To', 'corretto-restaurant'),
				'parent' => $wednesday_row
			));

			$thursday_group = corretto_elated_add_admin_group(array(
				'name'        => 'thursday_group',
				'title'       => esc_html__('Thursday', 'corretto-restaurant'),
				'parent'      => $panel_working_hours,
				'description' => 'Working hours for Thursday'
			));

			$thursday_row = corretto_elated_add_admin_row(array(
				'name'   => 'thursday_row',
				'parent' => $thursday_group
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_thursday_from',
				'type'   => 'textsimple',
				'label'  => esc_html__('From', 'corretto-restaurant'),
				'parent' => $thursday_row
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_thursday_to',
				'type'   => 'textsimple',
				'label'  => esc_html__('To', 'corretto-restaurant'),
				'parent' => $thursday_row
			));

			$friday_group = corretto_elated_add_admin_group(array(
				'name'        => 'friday_group',
				'title'       => esc_html__('Friday', 'corretto-restaurant'),
				'parent'      => $panel_working_hours,
				'description' => esc_html__('Working hours for Friday', 'corretto-restaurant')
			));

			$friday_row = corretto_elated_add_admin_row(array(
				'name'   => 'friday_row',
				'parent' => $friday_group
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_friday_from',
				'type'   => 'textsimple',
				'label'  => esc_html__('From', 'corretto-restaurant'),
				'parent' => $friday_row
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_friday_to',
				'type'   => 'textsimple',
				'label'  => esc_html__('To', 'corretto-restaurant'),
				'parent' => $friday_row
			));

			$saturday_group = corretto_elated_add_admin_group(array(
				'name'        => 'saturday_group',
				'title'       => esc_html__('Saturday', 'corretto-restaurant'),
				'parent'      => $panel_working_hours,
				'description' => esc_html__('Working hours for Saturday', 'corretto-restaurant')
			));

			$saturday_row = corretto_elated_add_admin_row(array(
				'name'   => 'saturday_row',
				'parent' => $saturday_group
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_saturday_from',
				'type'   => 'textsimple',
				'label'  => esc_html__('From', 'corretto-restaurant'),
				'parent' => $saturday_row
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_saturday_to',
				'type'   => 'textsimple',
				'label'  => esc_html__('To', 'corretto-restaurant'),
				'parent' => $saturday_row
			));

			$sunday_group = corretto_elated_add_admin_group(array(
				'name'        => 'sunday_group',
				'title'       => esc_html__('Sunday', 'corretto-restaurant'),
				'parent'      => $panel_working_hours,
				'description' => esc_html__('Working hours for Sunday', 'corretto-restaurant')
			));

			$sunday_row = corretto_elated_add_admin_row(array(
				'name'   => 'sunday_row',
				'parent' => $sunday_group
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_sunday_from',
				'type'   => 'textsimple',
				'label'  => esc_html__('From', 'corretto-restaurant'),
				'parent' => $sunday_row
			));

			corretto_elated_add_admin_field(array(
				'name'   => 'wh_sunday_to',
				'type'   => 'textsimple',
				'label'  => esc_html__('To', 'corretto-restaurant'),
				'parent' => $sunday_row
			));
		}

		add_action('corretto_elated_options_map', 'corretto_restaurant_options_map', 71); //one after elements
	}
}